/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.hdvui.view.vector.listener.event.ActionEvent;

public abstract class VectorShape
extends VectorComponent {
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    private int direction;
    private int size;
    private int[] xPoints;
    private int[] yPoints;

    public VectorShape(Color color, Color foregroundColor, Font font) {
        super(null, color, foregroundColor, font);
        this.setSize(10);
        this.setFocusable(false);
    }

    public VectorShape(Color color, Font font) {
        super(null, color, font);
        this.setSize(10);
        this.setFocusable(false);
    }

    public VectorShape(Color color) {
        super(null, color);
        this.setSize(10);
        this.setFocusable(false);
    }

    public void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        super.paintComponent(graphics, x, y, width, height);
        int[] xs = (int[])this.getxPoints().clone();
        int[] ys = (int[])this.getyPoints().clone();
        graphics.setColor(this.getColor());
        int nbPoints = xs.length;
        if (this.getDirection() == 0) {
            int i = 0;
            while (i < nbPoints) {
                xs[i] = x + xs[i] * width / 100;
                ys[i] = y + ys[i] * height / 100;
                ++i;
            }
            graphics.fillPolygon(xs, ys, nbPoints);
        } else if (this.getDirection() == 1) {
            int i = 0;
            while (i < nbPoints) {
                xs[i] = x + width - xs[i] * width / 100;
                ys[i] = y + ys[i] * height / 100;
                ++i;
            }
            graphics.fillPolygon(xs, ys, nbPoints);
        } else if (this.getDirection() == 3) {
            int i = 0;
            while (i < nbPoints) {
                xs[i] = y + xs[i] * height / 100;
                ys[i] = x + ys[i] * width / 100;
                ++i;
            }
            graphics.fillPolygon(ys, xs, nbPoints);
        } else if (this.getDirection() == 2) {
            int i = 0;
            while (i < nbPoints) {
                xs[i] = y + height - xs[i] * height / 100;
                ys[i] = x + ys[i] * width / 100;
                ++i;
            }
            graphics.fillPolygon(ys, xs, nbPoints);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int[] getxPoints() {
        return this.xPoints;
    }

    public void setxPoints(int[] xPoints) {
        this.xPoints = xPoints;
    }

    public int[] getyPoints() {
        return this.yPoints;
    }

    public void setyPoints(int[] yPoints) {
        this.yPoints = yPoints;
    }

    public void setPoints(int[] xPoints, int[] yPoints) {
        this.xPoints = xPoints;
        this.yPoints = yPoints;
    }

    public void focus(boolean focus) {
    }

    public void fireMouseCliked(MouseEvent e) {
        super.fireMouseCliked(e);
        this.fireActionPerformed(new ActionEvent(this));
    }

    public void destroy() {
        this.xPoints = null;
        this.yPoints = null;
    }
}

