/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.hdvui.view.vector.VectorScrollBarListener;
import me.iste.hdvui.view.vector.observer.VectorComponentObserver;

public class VectorScrollBar
extends VectorComponent {
    private final List<VectorComponentObserver> vectorComponentObservers;
    private float value;
    private Point dragPoint;
    private boolean drag;

    public VectorScrollBar(Object text, Color color, Color foregroundColor, Font font) {
        super(text, color, foregroundColor, font);
        this.setFocusable(false);
        this.value = 1.0f;
        VectorScrollBarListener listener = new VectorScrollBarListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.vectorComponentObservers = new ArrayList<VectorComponentObserver>();
    }

    public VectorScrollBar(Object text, Color color, Font font) {
        super(text, color, Color.BLACK, font);
        this.setFocusable(false);
        this.value = 1.0f;
        VectorScrollBarListener listener = new VectorScrollBarListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.vectorComponentObservers = new ArrayList<VectorComponentObserver>();
    }

    public VectorScrollBar(Object text, Color color) {
        super(text, color);
        this.setFocusable(false);
        this.value = 1.0f;
        VectorScrollBarListener listener = new VectorScrollBarListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.vectorComponentObservers = new ArrayList<VectorComponentObserver>();
    }

    public void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        super.paintComponent(graphics, x, y, width, height);
        graphics.setColor(this.getColor());
        graphics.drawLine(x + width / 2, y, x + width / 2, y + height);
        graphics.drawLine(x + width / 2 + 1, y, x + width / 2 + 1, y + height);
        graphics.drawLine(x + width / 2 - 1, y, x + width / 2 - 1, y + height);
        float val = this.value;
        int heightScroller = height * 10 / 100;
        int yScroller = y + height - heightScroller - (int)((float)(height - heightScroller) * val);
        graphics.fillRect(x, yScroller, width, heightScroller);
        graphics.setColor(this.getColor().darker());
        graphics.drawRect(x, yScroller, width, heightScroller);
        graphics.drawRect(x + 1, yScroller + 1, width - 2, heightScroller - 2);
        graphics.drawRect(x + 2, yScroller + 2, width - 4, heightScroller - 4);
    }

    public void mousePressed(MouseEvent e) {
        int[] values = this.getLastSeen();
        int heightScroller = values[3] * 10 / 100;
        int yScroller = values[1] + values[3] - heightScroller - (int)((float)(values[3] - heightScroller) * this.value);
        if (e.getX() >= values[0] && e.getX() <= values[0] + values[2] && e.getY() >= yScroller && e.getY() <= yScroller + heightScroller) {
            this.dragPoint = e.getPoint();
            this.drag = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragPoint = e.getPoint();
        this.drag = false;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.drag) {
            int[] values = this.getLastSeen();
            int heightScroller = values[3] * 10 / 100;
            if (this.dragPoint == null) {
                this.dragPoint = e.getPoint();
            } else {
                float valueAdd = (float)((this.dragPoint.getY() - (double)e.getY()) / (double)(values[3] - heightScroller));
                this.setValue(this.getValue() + valueAdd);
                this.dragPoint = e.getPoint();
                this.repaint();
            }
        }
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        float val = value;
        if (val < 0.0f) {
            val = 0.0f;
        }
        if (val > 1.0f) {
            val = 1.0f;
        }
        this.value = val;
        this.fireValueChange();
    }

    public void addObserver(VectorComponentObserver observer) {
        this.vectorComponentObservers.add(observer);
    }

    public void removeObserver(VectorComponentObserver observer) {
        this.vectorComponentObservers.remove(observer);
    }

    public void fireValueChange() {
        for (VectorComponentObserver observer : this.vectorComponentObservers) {
            observer.componentChanged();
        }
    }
}

