/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import me.iste.hdvui.view.vector.VectorComponent;

public class VectorProgressBar
extends VectorComponent {
    private int value;
    private int total;

    public VectorProgressBar(Object userObject, Color color, Color foregroundColor, Font font) {
        super(userObject, color, foregroundColor, font);
        this.setFocusable(false);
    }

    public VectorProgressBar(Object text, Color color, Font font) {
        super(text, color, font);
        this.setFocusable(false);
    }

    public VectorProgressBar(Object text, Color color) {
        super(text, color);
        this.setFocusable(false);
    }

    public void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        super.paintComponent(graphics, x, y, width, height);
        int xPos = x + (int)((1.0f - this.getZoom()) * (float)width / 2.0f);
        int yPos = y + (int)((1.0f - this.getZoom()) * (float)height / 2.0f);
        if (this.total > 0) {
            graphics.setColor(this.getColor().darker());
            graphics.fillRect(xPos, yPos, width, height);
            graphics.setColor(this.getColor());
            graphics.fillRect(xPos, yPos, width * this.value / this.total, height);
            graphics.setColor(this.getColor().brighter());
            graphics.drawRect(xPos, yPos, width, height);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }
}

