/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import me.iste.hdvui.tools.util.ImageContainer;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.hdvui.view.vector.VectorImageListener;

public class VectorImage
extends VectorComponent {
    private ImageContainer image;
    private boolean anime;
    private boolean charge;
    private final int[] lastDraw = new int[4];
    private boolean drag;
    private Point dragPoint;
    private int xImage;
    private int yImage;

    public VectorImage(Object userObject, Color color, Color foregroundColor, Font font) {
        super(userObject, color, foregroundColor, font);
        VectorImageListener listener = new VectorImageListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.setFocusable(false);
        System.out.println("________Hi, i'm " + this);
        VectorImage.addToPlay(this);
    }

    public VectorImage(Object userObject, Color color, Font font) {
        super(userObject, color, font);
        VectorImageListener listener = new VectorImageListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.setFocusable(false);
        VectorImage.addToPlay(this);
    }

    public VectorImage(Object userObject, Color color) {
        super(userObject, color);
        VectorImageListener listener = new VectorImageListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.setFocusable(false);
        VectorImage.addToPlay(this);
    }

    public void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        int finalWidth;
        int finalHeight;
        float componentRatio;
        int imageHeight;
        super.paintComponent(graphics, x, y, width, height);
        Image img = this.image.getImage();
        if (img == null) {
            return;
        }
        int imageWidth = img.getWidth(null);
        float imageRatio = (float)imageWidth / (float)(imageHeight = img.getHeight(null));
        if (imageRatio < (componentRatio = (float)width / (float)height)) {
            finalHeight = height;
            finalWidth = imageWidth * height / imageHeight;
        } else {
            finalWidth = width;
            finalHeight = imageHeight * width / imageWidth;
        }
        float zoom = this.getZoom();
        if ((double)zoom < 0.02) {
            zoom = 0.02f;
        }
        this.setZoom(zoom);
        int finalWidthZoom = (int)((float)finalWidth / zoom);
        int finalHeightZoom = (int)((float)finalHeight / zoom);
        if (finalWidthZoom > width) {
            if (this.xImage > 0) {
                this.xImage = 0;
            } else if (this.xImage < width - finalWidthZoom) {
                this.xImage = width - finalWidthZoom;
            }
        } else {
            this.xImage = width / 2 - finalWidthZoom / 2;
        }
        if (finalHeightZoom > height) {
            if (this.yImage > 0) {
                this.yImage = 0;
            } else if (this.yImage < height - finalHeightZoom) {
                this.yImage = height - finalHeightZoom;
            }
        } else {
            this.yImage = height / 2 - finalHeightZoom / 2;
        }
        int finalX = this.xImage + x;
        int finalY = this.yImage + y;
        this.lastDraw[0] = finalX;
        this.lastDraw[1] = finalY;
        this.lastDraw[2] = finalWidthZoom;
        this.lastDraw[3] = finalHeightZoom;
        if (!this.charge) {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(this.lastDraw[0], this.lastDraw[1], this.lastDraw[2], this.lastDraw[3]);
        }
        this.charge = graphics.drawImage(img, this.lastDraw[0], this.lastDraw[1], this.lastDraw[2], this.lastDraw[3], null);
        if (this.charge && this.image.getAlt() != null && img == this.image.getAlt().getImage()) {
            this.charge = false;
        }
    }

    public ImageContainer getImage() {
        return this.image;
    }

    public void setImage(ImageContainer image) {
        this.image = image;
    }

    public void anime(boolean value) {
        this.anime = value;
        if (value) {
            VectorImage.addToPlay(this);
        }
    }

    public boolean needPlay() {
        return super.needPlay() || this.anime || !this.charge;
    }

    public void mousePressed(Point point) {
        if (point.getX() >= (double)this.lastDraw[0] && point.getX() <= (double)(this.lastDraw[0] + this.lastDraw[2]) && point.getY() >= (double)this.lastDraw[1] && point.getY() <= (double)(this.lastDraw[1] + this.lastDraw[3])) {
            this.dragPoint = point;
            this.drag = true;
        } else {
            this.drag = false;
        }
    }

    public void mouseReleased(Point point) {
        this.dragPoint = point;
        this.drag = false;
    }

    public void mouseDragged(Point point) {
        if (this.drag) {
            if (this.dragPoint == null) {
                this.dragPoint = point;
            } else {
                if (this.lastDraw[2] > this.getLastSeen()[2]) {
                    this.xImage += (int)(point.getX() - this.dragPoint.getX());
                    if (this.xImage > 0) {
                        this.xImage = 0;
                    } else if (this.xImage < this.getLastSeen()[2] - this.lastDraw[2]) {
                        this.xImage = this.getLastSeen()[2] - this.lastDraw[2];
                    }
                } else {
                    this.xImage = this.getLastSeen()[2] / 2 - this.lastDraw[2] / 2;
                }
                if (this.lastDraw[3] > this.getLastSeen()[3]) {
                    this.yImage += (int)(point.getY() - this.dragPoint.getY());
                    if (this.yImage > 0) {
                        this.yImage = 0;
                    } else if (this.yImage < this.getLastSeen()[3] - this.lastDraw[3]) {
                        this.yImage = this.getLastSeen()[3] - this.lastDraw[3];
                    }
                } else {
                    this.yImage = this.getLastSeen()[3] / 2 - this.lastDraw[3] / 2;
                }
                this.dragPoint = point;
                this.repaint();
            }
        }
    }

    public void zoom(int wheelRotation, Point point) {
        int finalWidth;
        int finalHeight;
        Image img = this.image.getImage();
        this.setZoom(this.getZoom() + (float)wheelRotation / 50.0f);
        float zoomImageX = (float)(point.getX() - (double)this.lastDraw[0]) * 100.0f / (float)this.lastDraw[2];
        float zoomImageY = (float)(point.getY() - (double)this.lastDraw[1]) * 100.0f / (float)this.lastDraw[3];
        int zoomPointX = (int)point.getX();
        int zoomPointY = (int)point.getY();
        int imageWidth = img.getWidth(null);
        int imageHeight = img.getHeight(null);
        float imageRatio = (float)imageWidth / (float)imageHeight;
        float componentRatio = (float)this.getLastSeen()[2] / (float)this.getLastSeen()[3];
        if (imageRatio < componentRatio) {
            finalHeight = this.getLastSeen()[3];
            finalWidth = imageWidth * this.getLastSeen()[3] / imageHeight;
        } else {
            finalWidth = this.getLastSeen()[2];
            finalHeight = imageHeight * this.getLastSeen()[2] / imageWidth;
        }
        float zoom = this.getZoom();
        if ((double)zoom < 0.02) {
            zoom = 0.02f;
        }
        this.setZoom(zoom);
        int finalWidthZoom = (int)((float)finalWidth / zoom);
        int finalHeightZoom = (int)((float)finalHeight / zoom);
        this.xImage = zoomPointX - Math.round(zoomImageX * (float)finalWidthZoom / 100.0f);
        this.yImage = zoomPointY - Math.round(zoomImageY * (float)finalHeightZoom / 100.0f);
        if (finalWidthZoom > this.getLastSeen()[2]) {
            if (this.xImage > 0) {
                this.xImage = 0;
            } else if (this.xImage < this.getLastSeen()[2] - finalWidthZoom) {
                this.xImage = this.getLastSeen()[2] - finalWidthZoom;
            }
        } else {
            this.xImage = this.getLastSeen()[2] / 2 - finalWidthZoom / 2;
        }
        if (finalHeightZoom > this.getLastSeen()[3]) {
            if (this.yImage > 0) {
                this.yImage = 0;
            } else if (this.yImage < this.getLastSeen()[3] - finalHeightZoom) {
                this.yImage = this.getLastSeen()[3] - finalHeightZoom;
            }
        } else {
            this.yImage = this.getLastSeen()[3] / 2 - finalHeightZoom / 2;
        }
        this.repaint();
    }

    public void destroy() {
        super.destroy();
        this.anime(false);
        this.setImage(null);
    }
}

