/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import java.util.logging.Level;
import me.iste.hdvui.tools.IconTools;
import me.iste.hdvui.tools.util.Shape;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.tools.instantiation.Instantiation;
import me.iste.tools.log.Log;

public class VectorIcon
extends VectorComponent {
    private final List<Shape> shapes;
    private boolean text;

    public VectorIcon(Object userObject, Color color, Color foregroundColor, Font font, String icon) {
        super(userObject, color, foregroundColor, font);
        this.shapes = IconTools.getIconShapes(icon);
        this.setText(true);
    }

    public VectorIcon(Object text, Color color, Font font, String icon) {
        super(text, color, font);
        this.shapes = IconTools.getIconShapes(icon);
        this.setText(true);
    }

    public VectorIcon(Object text, Color color, String icon) {
        super(text, color);
        this.shapes = IconTools.getIconShapes(icon);
        this.setText(true);
    }

    public void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        Graphics2D graphics2d;
        block27: {
            super.paintComponent(graphics, x, y, width, height);
            graphics2d = (Graphics2D)graphics;
            int xPos = x + (int)((1.0f - this.getZoom()) * (float)width / 2.0f);
            int yPos = y + (int)((1.0f - this.getZoom()) * (float)height / 2.0f);
            List shapesList = Instantiation.getList();
            shapesList.addAll(this.shapes);
            Stroke oldStroke = graphics2d.getStroke();
            try {
                try {
                    for (Shape shape : shapesList) {
                        int shapeHeight;
                        int shapeWidth;
                        Color color = Color.BLACK;
                        if (shape.getColorType().equals((Object)Shape.ColorType.primary)) {
                            color = this.getColor();
                        } else if (shape.getColorType().equals((Object)Shape.ColorType.secondary)) {
                            color = this.getForegroundColor();
                        } else if (shape.getColorType().equals((Object)Shape.ColorType.custom)) {
                            color = shape.getColor();
                        }
                        int modifier = shape.getColorModifier();
                        while (modifier != 0) {
                            if (modifier < 0) {
                                ++modifier;
                                color = color.darker();
                                continue;
                            }
                            --modifier;
                            color = color.brighter();
                        }
                        graphics2d.setColor(color);
                        if (shape.getSize() != null) {
                            BasicStroke stroke = new BasicStroke(this.percent(shape.getSize(), width));
                            graphics2d.setStroke(stroke);
                        }
                        if (shape.getType().equals((Object)Shape.ShapeType.rectangle)) {
                            int shapeX = xPos + this.percent(shape.getXs().get(0), width);
                            int shapeY = yPos + this.percent(shape.getYs().get(0), height);
                            shapeWidth = this.percent(shape.getXs().get(1), width);
                            shapeHeight = this.percent(shape.getYs().get(1), height);
                            if (shape.isFill()) {
                                graphics2d.fillRect(shapeX, shapeY, shapeWidth, shapeHeight);
                                continue;
                            }
                            graphics2d.drawRect(shapeX, shapeY, shapeWidth, shapeHeight);
                            continue;
                        }
                        if (shape.getType().equals((Object)Shape.ShapeType.oval)) {
                            int shapeX = xPos + this.percent(shape.getXs().get(0), width);
                            int shapeY = yPos + this.percent(shape.getYs().get(0), height);
                            shapeWidth = this.percent(shape.getXs().get(1), width);
                            shapeHeight = this.percent(shape.getYs().get(1), height);
                            if (shape.isFill()) {
                                graphics2d.fillOval(shapeX, shapeY, shapeWidth, shapeHeight);
                                continue;
                            }
                            graphics2d.drawOval(shapeX, shapeY, shapeWidth, shapeHeight);
                            continue;
                        }
                        if (shape.getType().equals((Object)Shape.ShapeType.roundRect)) {
                            int shapeX = xPos + this.percent(shape.getXs().get(0), width);
                            int shapeY = yPos + this.percent(shape.getYs().get(0), height);
                            shapeWidth = this.percent(shape.getXs().get(1), width);
                            shapeHeight = this.percent(shape.getYs().get(1), height);
                            int shapeArcWidth = this.percent(shape.getXs().get(2), width);
                            int shapeArcHeight = this.percent(shape.getYs().get(2), height);
                            if (shape.isFill()) {
                                graphics2d.fillRoundRect(shapeX, shapeY, shapeWidth, shapeHeight, shapeArcWidth, shapeArcHeight);
                                continue;
                            }
                            graphics2d.drawRoundRect(shapeX, shapeY, shapeWidth, shapeHeight, shapeArcWidth, shapeArcHeight);
                            continue;
                        }
                        if (shape.getType().equals((Object)Shape.ShapeType.line)) {
                            int shapeX1 = xPos + this.percent(shape.getXs().get(0), width);
                            int shapeY1 = yPos + this.percent(shape.getYs().get(0), height);
                            int shapeX2 = xPos + this.percent(shape.getXs().get(1), width);
                            int shapeY2 = yPos + this.percent(shape.getYs().get(1), height);
                            graphics2d.drawLine(shapeX1, shapeY1, shapeX2, shapeY2);
                            continue;
                        }
                        if (shape.getType().equals((Object)Shape.ShapeType.polygon)) {
                            int[] xPoints = new int[shape.getXs().size()];
                            int i = 0;
                            while (i < shape.getXs().size()) {
                                xPoints[i] = xPos + this.percent(shape.getXs().get(i), width);
                                ++i;
                            }
                            int[] yPoints = new int[shape.getYs().size()];
                            int i2 = 0;
                            while (i2 < shape.getYs().size()) {
                                yPoints[i2] = yPos + this.percent(shape.getYs().get(i2), height);
                                ++i2;
                            }
                            if (shape.isFill()) {
                                graphics2d.fillPolygon(xPoints, yPoints, shape.getXs().size());
                                continue;
                            }
                            graphics2d.drawPolygon(xPoints, yPoints, shape.getXs().size());
                            continue;
                        }
                        if (!shape.getType().equals((Object)Shape.ShapeType.arc)) continue;
                        int shapeX = xPos + this.percent(shape.getXs().get(0), width);
                        int shapeY = yPos + this.percent(shape.getYs().get(0), height);
                        shapeWidth = this.percent(shape.getXs().get(1), width);
                        shapeHeight = this.percent(shape.getYs().get(1), height);
                        int shapeStartAngle = shape.getXs().get(2);
                        int shapeArcAngle = shape.getYs().get(2);
                        if (shape.isFill()) {
                            graphics2d.fillArc(shapeX, shapeY, shapeWidth, shapeHeight, shapeStartAngle, shapeArcAngle);
                            continue;
                        }
                        graphics2d.drawArc(shapeX, shapeY, shapeWidth, shapeHeight, shapeStartAngle, shapeArcAngle);
                    }
                }
                catch (Exception e) {
                    Log.log((Exception)e, (Level)Level.WARNING);
                    graphics2d.setStroke(oldStroke);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                graphics2d.setStroke(oldStroke);
                throw throwable;
            }
            graphics2d.setStroke(oldStroke);
        }
        if (this.isText()) {
            graphics2d.setColor(this.getColor());
            VectorIcon.printString(graphics2d, this.getUserObject().toString(), x, y, width, height, VectorComponent.Alignment.center, VectorComponent.Alignment.bottom, 0.5);
        }
    }

    protected int percent(int percent, int value) {
        return (int)((float)super.percent(percent, value) * this.getZoom());
    }

    public void reload(String icon) {
        this.shapes.clear();
        this.shapes.addAll(IconTools.getIconShapes(icon));
    }

    public boolean isText() {
        return this.text;
    }

    public void setText(boolean text) {
        this.text = text;
    }
}

