/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.hdvui.view.vector.VectorContainer;

public class VectorGroupe
extends VectorContainer {
    private float row;
    private float column;
    private int padx;
    private int pady;

    public VectorGroupe(Object text, Color color, Color foregroundColor, Font font) {
        super(text, color, foregroundColor, font);
        this.setFocusable(false);
    }

    public VectorGroupe(Object text, Color color, Font font) {
        super(text, color, font);
        this.setFocusable(false);
    }

    public VectorGroupe(Object text, Color color) {
        super(text, color);
        this.setFocusable(false);
    }

    public void init(float x, float y, int ipadx, int ipady) {
        this.column = x;
        this.row = y;
        this.padx = ipadx;
        this.pady = ipady;
    }

    public void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        int titleBarSize;
        super.paintComponent(graphics, x, y, width, height);
        if (this.getUserObject() != null) {
            graphics.setColor(this.getColor());
            graphics.fillRect(x, y, width, height);
            titleBarSize = height * 15 / 100;
            int margeTitleBarSize = width * 25 / 100;
            graphics.setColor(this.getForegroundColor());
            VectorGroupe.printString(graphics, this.getUserObject().toString(), x + margeTitleBarSize, y, width - margeTitleBarSize * 2, titleBarSize, VectorComponent.Alignment.center, VectorComponent.Alignment.center);
        } else {
            titleBarSize = 0;
        }
        this.painElements(graphics, x, y + titleBarSize, width, height - titleBarSize);
    }

    protected void painElements(Graphics graphics, int x, int y, int width, int height) {
        int itemWidth = (int)((float)width / this.column);
        int itemHeight = (int)((float)height / this.row);
        int xIndex = 0;
        int yIndex = 0;
        int xDraw = x + this.padx;
        int yDraw = y + this.pady;
        for (VectorComponent component : this.getVectorComponents()) {
            int xComponent = xDraw + xIndex * itemWidth;
            int yComponent = yDraw + yIndex * itemHeight;
            int widthComponent = itemWidth - 2 * this.padx;
            int heightComponent = itemHeight - 2 * this.pady;
            component.paint(graphics, xComponent, yComponent, widthComponent, heightComponent);
            ++xIndex;
            if (!((float)xIndex >= this.column)) continue;
            xIndex = 0;
            ++yIndex;
        }
    }

    public float getRow() {
        float val = this.row + (1.0f - this.getZoom()) * this.row * 2.0f;
        return val;
    }

    public void setRow(float row) {
        this.row = row;
    }

    public float getColumn() {
        float val = this.column + (1.0f - this.getZoom()) * this.column * 2.0f;
        return val;
    }

    public void setColumn(float column) {
        this.column = column;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPadx(int padx) {
        this.padx = padx;
    }

    public int getPady() {
        return this.pady;
    }

    public void setPady(int pady) {
        this.pady = pady;
    }
}

