/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.iste.hdvui.settings.SettingsConstantes;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.hdvui.view.vector.observer.VectorComponentObserver;
import me.iste.tools.settings.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VectorContainer
extends VectorComponent
implements VectorComponentObserver {
    private final List<VectorComponent> vectorComponents = new ArrayList<VectorComponent>();
    private VectorComponent focus;
    private VectorComponent lastDownClic;
    private VectorComponent componentOver;
    private Point lastDownPoint;

    public VectorContainer(Object text, Color color, Color foregroundColor, Font font) {
        super(text, color, foregroundColor, font);
    }

    public VectorContainer(Object text, Color color, Font font) {
        super(text, color, font);
    }

    public VectorContainer(Object text, Color color) {
        super(text, color);
    }

    public void addComponent(VectorComponent vectorComponent) {
        this.vectorComponents.add(vectorComponent);
        vectorComponent.addVectorComponentObserver(this);
    }

    @Override
    public void componentChanged() {
        this.repaint();
    }

    public List<VectorComponent> getVectorComponents() {
        return this.vectorComponents;
    }

    protected VectorComponent getComponentUnder(MouseEvent e) {
        Collections.reverse(this.getVectorComponents());
        VectorComponent value = null;
        for (VectorComponent component : this.getVectorComponents()) {
            if (!component.isIn(e.getPoint())) continue;
            value = component;
            break;
        }
        Collections.reverse(this.getVectorComponents());
        return value;
    }

    public VectorComponent getFocused() {
        return this.focus;
    }

    public void setFocus(VectorComponent focus) {
        this.focus = focus;
    }

    public boolean focusIsFirst() {
        return this.getVectorComponents().indexOf(this.getFocused()) == 0;
    }

    public boolean focusIsLast() {
        return this.getVectorComponents().indexOf(this.getFocused()) + 1 == this.getVectorComponents().size();
    }

    public void focusNext() {
        if (!this.focusIsLast()) {
            int index = this.getVectorComponents().indexOf(this.getFocused());
            if (this.getFocused() != null) {
                this.getFocused().focus(false);
            }
            VectorComponent focusComponent = this.getVectorComponents().get(index + 1);
            focusComponent.focus(true);
            this.setFocus(focusComponent);
        }
    }

    public VectorComponent getFocusNext() {
        VectorComponent component;
        if (!this.focusIsLast()) {
            VectorComponent focusComponent;
            int index = this.getVectorComponents().indexOf(this.getFocused());
            component = focusComponent = this.getVectorComponents().get(index + 1);
        } else {
            component = null;
        }
        return component;
    }

    public void focusPrevious() {
        if (!this.focusIsFirst()) {
            int index = this.getVectorComponents().indexOf(this.getFocused());
            if (this.getFocused() != null) {
                this.getFocused().focus(false);
            }
            VectorComponent focusComponent = this.getVectorComponents().get(index - 1);
            focusComponent.focus(true);
            this.setFocus(focusComponent);
        }
    }

    public VectorComponent getFocusPrevious() {
        VectorComponent component;
        if (!this.focusIsFirst()) {
            VectorComponent focusComponent;
            int index = this.getVectorComponents().indexOf(this.getFocused());
            component = focusComponent = this.getVectorComponents().get(index - 1);
        } else {
            component = null;
        }
        return component;
    }

    @Override
    public void fireMouseCliked(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            VectorComponent component = this.getComponentUnder(e);
            if (component != null) {
                component.fireMouseCliked(e);
            }
            super.fireMouseCliked(e);
        }
    }

    @Override
    public void fireMousePressed(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            VectorComponent component = this.getComponentUnder(e);
            if (component != null) {
                this.lastDownClic = component;
                component.fireMousePressed(e);
            }
            super.fireMousePressed(e);
            if (!e.isConsumed()) {
                this.lastDownPoint = e.getPoint();
                if (this.focus != null && this.focus != component) {
                    this.focus.focus(false);
                }
            }
        }
    }

    @Override
    public void fireMouseReleased(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            VectorComponent component = this.getComponentUnder(e);
            if (component != null) {
                component.fireMouseReleased(e);
                if (this.lastDownPoint != null && this.lastDownPoint.distance(e.getX(), e.getY()) <= (double)((Integer)Settings.getInfo((String)SettingsConstantes.ERROR_CLIC_VALUE, Integer.class)).intValue() && !e.isConsumed() && !this.moving() && component == this.lastDownClic) {
                    if (this.focus != null && this.focus != component) {
                        this.focus.focus(false);
                    }
                    component.focus(true);
                    this.focus = component;
                }
                if (this.lastDownClic != null && this.lastDownClic != component) {
                    this.lastDownClic.fireMouseReleased(e);
                }
            } else {
                if (this.focus != null) {
                    this.focus.focus(false);
                    this.focus = null;
                }
                if (this.lastDownClic != null) {
                    this.lastDownClic.fireMouseReleased(e);
                }
            }
            super.fireMouseReleased(e);
        }
    }

    @Override
    public void fireMouseEntered(MouseEvent e) {
        VectorComponent component;
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed() && (component = this.getComponentUnder(e)) != null) {
            component.fireMouseEntered(e);
        }
        super.fireMouseEntered(e);
    }

    @Override
    public void fireMouseExited(MouseEvent e) {
        VectorComponent component;
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed() && (component = this.getComponentUnder(e)) != null) {
            component.fireMouseExited(e);
        }
        super.fireMouseExited(e);
    }

    @Override
    public void fireMouseDragged(MouseEvent e) {
        VectorComponent component = this.getComponentUnder(e);
        if (component != null) {
            component.fireMouseDragged(e);
        }
        if (this.componentOver != component) {
            if (this.componentOver != null) {
                this.componentOver.fireMouseExited(e);
            }
            if (component != null) {
                component.fireMouseEntered(e);
            }
        }
        this.componentOver = component;
        super.fireMouseDragged(e);
    }

    @Override
    public void fireMouseMoved(MouseEvent e) {
        VectorComponent component = this.getComponentUnder(e);
        if (component != null) {
            component.fireMouseMoved(e);
        }
        if (this.componentOver != component) {
            if (this.componentOver != null) {
                this.componentOver.fireMouseExited(e);
            }
            if (component != null) {
                component.fireMouseEntered(e);
            }
        }
        this.componentOver = component;
        super.fireMouseMoved(e);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (VectorComponent component : this.vectorComponents) {
            component.destroy();
        }
    }
}

