/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.iste.hdvui.view.constantes.ColorConstantes;
import me.iste.hdvui.view.vector.VectorThread;
import me.iste.hdvui.view.vector.listener.ActionListener;
import me.iste.hdvui.view.vector.listener.event.ActionEvent;
import me.iste.hdvui.view.vector.observer.VectorComponentFocusObserver;
import me.iste.hdvui.view.vector.observer.VectorComponentObserver;
import me.iste.tools.log.Log;

public abstract class VectorComponent {
    private static final VectorThread vectorThread = new VectorThread();
    private Object userObject;
    private Color color;
    private Color foregroundColor;
    private final Font font;
    private boolean focused;
    private boolean focusable;
    private boolean cliping;
    private float zoom;
    private float xDecal;
    private float yDecal;
    private float xDecalPos;
    private float yDecalPos;
    private final int[] lastSeen;
    private final List<MouseListener> mouseListeners;
    private final List<MouseMotionListener> mouseMotionListeners;
    private final List<VectorComponentObserver> observers;
    private final List<VectorComponentFocusObserver> vectorComponentFocusObservers;
    private final List<MouseWheelListener> mouseWheelListeners;
    private final List<ActionListener> actionListeners;

    public VectorComponent(Object userObject, Color color, Color foregroundColor, Font font) {
        this.userObject = userObject;
        this.color = color;
        this.foregroundColor = foregroundColor;
        this.font = font;
        this.zoom = 1.0f;
        this.focusable = true;
        this.lastSeen = new int[4];
        this.mouseListeners = new ArrayList<MouseListener>();
        this.mouseMotionListeners = new ArrayList<MouseMotionListener>();
        this.observers = new ArrayList<VectorComponentObserver>();
        this.vectorComponentFocusObservers = new ArrayList<VectorComponentFocusObserver>();
        this.mouseWheelListeners = new ArrayList<MouseWheelListener>();
        this.actionListeners = new ArrayList<ActionListener>();
    }

    public VectorComponent(Object text, Color color, Font font) {
        this(text, color, Color.BLACK, font);
    }

    public VectorComponent(Object text, Color color) {
        this(text, color, Color.BLACK, null);
    }

    protected void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        this.lastSeen[0] = x;
        this.lastSeen[1] = y;
        this.lastSeen[2] = width;
        this.lastSeen[3] = height;
    }

    protected void paintBackGroundFocus(Graphics graphics, int x, int y, int width, int height) {
        if (this.isFocused() && this.isFocusable()) {
            graphics.setColor(ColorConstantes.FOCUS_BACKGROUND);
            graphics.fillRect(x - 1, y - 1, width + 3, height + 3);
        }
    }

    protected void paintForeGroundFocus(Graphics graphics, int x, int y, int width, int height) {
        if (this.isFocused() && this.isFocusable()) {
            graphics.setColor(ColorConstantes.FOCUS_FOREGROUND);
            graphics.fillRect(x - 1, y - 1, width + 3, height + 3);
        }
    }

    public void paint(Graphics graphics, int x, int y, int width, int height) {
        int xPos = x + this.getxDecal(width);
        int yPos = y + this.getyDecal(height);
        Shape oldClip = graphics.getClip();
        if (this.cliping) {
            Area drawClipArea;
            if (oldClip == null) {
                drawClipArea = null;
            } else {
                Area oldClipArea = new Area(oldClip);
                Rectangle drawClip = new Rectangle(xPos, yPos, width, height);
                drawClipArea = new Area(drawClip);
                drawClipArea.intersect(oldClipArea);
            }
            graphics.setClip(drawClipArea);
        }
        this.paintBackGroundFocus(graphics, xPos, yPos, width, height);
        this.paintComponent(graphics, xPos, yPos, width, height);
        this.paintForeGroundFocus(graphics, xPos, yPos, width, height);
        graphics.setClip(oldClip);
    }

    public void play() {
        this.xDecal = (double)this.xDecalPos - 0.02 > (double)this.xDecal ? (float)((double)this.xDecal + 0.02) : ((double)this.xDecalPos + 0.02 < (double)this.xDecal ? (float)((double)this.xDecal - 0.02) : this.xDecalPos);
        this.yDecal = (double)this.yDecalPos - 0.02 > (double)this.yDecal ? (float)((double)this.yDecal + 0.02) : ((double)this.yDecalPos + 0.02 < (double)this.yDecal ? (float)((double)this.yDecal - 0.02) : this.yDecalPos);
        this.repaint();
    }

    public boolean needPlay() {
        return this.xDecal != this.xDecalPos || this.yDecal != this.yDecalPos;
    }

    public static void addToPlay(VectorComponent component) {
        vectorThread.add(component);
    }

    public int[] getLastSeen() {
        return this.lastSeen;
    }

    public boolean isIn(Point point) {
        int[] lastSeenPos = this.getLastSeen();
        return point.getX() >= (double)lastSeenPos[0] && point.getX() <= (double)(lastSeenPos[0] + lastSeenPos[2]) && point.getY() >= (double)lastSeenPos[1] && point.getY() <= (double)(lastSeenPos[1] + lastSeenPos[3]);
    }

    public boolean moving() {
        return this.xDecal != this.xDecalPos || this.yDecal != this.yDecalPos;
    }

    public float getxDecal() {
        return this.xDecal;
    }

    public void setxDecal(float xDecal) {
        this.xDecal = xDecal;
        if (this.xDecalPos != this.xDecal) {
            VectorComponent.addToPlay(this);
        }
    }

    public float getyDecal() {
        return this.yDecal;
    }

    public void setyDecal(float yDecal) {
        this.yDecal = yDecal;
        if (this.xDecalPos != this.xDecal) {
            VectorComponent.addToPlay(this);
        }
    }

    public float getxDecalPos() {
        return this.xDecalPos;
    }

    public void setxDecalPos(float xDecalPos) {
        this.xDecalPos = xDecalPos;
        if (this.xDecalPos != this.xDecal) {
            VectorComponent.addToPlay(this);
        }
    }

    public float getyDecalPos() {
        return this.yDecalPos;
    }

    public void setyDecalPos(float yDecalPos) {
        this.yDecalPos = yDecalPos;
        if (this.yDecalPos != this.yDecal) {
            VectorComponent.addToPlay(this);
        }
    }

    public int getxDecal(int width) {
        return (int)(this.xDecal * (float)width);
    }

    public int getyDecal(int height) {
        return (int)(this.yDecal * (float)height);
    }

    protected int percent(int percent, int value) {
        return percent * value / 100;
    }

    public static void printString(Graphics graphics, String string, int x, int y, int width, int height, Alignment hCenter, Alignment vCenter, double ratioValue) {
        Graphics2D graphics2d = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2d.getFontRenderContext();
        Font font = graphics2d.getFont();
        Rectangle2D stringBounds = font.getStringBounds(string, fontRenderContext);
        double squareRatio = (double)(width * height) / (stringBounds.getWidth() * stringBounds.getHeight());
        double ratio = Math.sqrt(squareRatio);
        double ajustedRatio = ratio * ratioValue;
        char[] charArray = string.toCharArray();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
        affineTransform.scale(ajustedRatio, ajustedRatio);
        Font newFont = font.deriveFont(affineTransform);
        graphics2d.setFont(newFont);
        FontMetrics fontMetrics = graphics2d.getFontMetrics();
        int fontAscent = fontMetrics.getAscent();
        int fontDescent = fontMetrics.getDescent();
        int fontFinalHeight = fontAscent + fontDescent;
        ArrayList<int[]> linesList = new ArrayList<int[]>();
        int index = 0;
        int line = 1;
        boolean continuer = true;
        while (continuer) {
            int i = index;
            while (i < charArray.length) {
                if (newFont.getStringBounds(charArray, index, i + 1, fontRenderContext).getWidth() > (double)(width - 2)) {
                    int endLine = i;
                    block2: while (charArray[i] != ' ') {
                        if (--i <= index) {
                            i = endLine;
                            break;
                        }
                        if (charArray[i] != ' ') continue;
                        while (charArray[i] == ' ') {
                            if (--i != index) continue;
                            i = endLine;
                            break block2;
                        }
                        break block2;
                    }
                    ++i;
                    break;
                }
                ++i;
            }
            int heightString = line * fontFinalHeight;
            int yString = y + heightString - fontDescent;
            int xString = hCenter == Alignment.right ? x + width - (int)newFont.getStringBounds(string.substring(index, i).trim(), fontRenderContext).getWidth() : (hCenter == Alignment.center ? x + 1 + (width - (int)newFont.getStringBounds(string.substring(index, i).trim(), fontRenderContext).getWidth()) / 2 : x + 1);
            int[] values = new int[]{index, i, xString, yString};
            linesList.add(values);
            index = i;
            ++line;
            while (index < charArray.length && charArray[index] == ' ') {
                ++index;
            }
            if (index < charArray.length) continue;
            continuer = false;
        }
        for (int[] values : linesList) {
            if (vCenter == Alignment.center) {
                values[3] = values[3] + ((height - line * fontFinalHeight) / 2 + fontFinalHeight / 2);
            } else if (vCenter == Alignment.bottom) {
                values[3] = values[3] + (height - (line - 1) * fontFinalHeight);
            }
            graphics2d.drawString(string.substring(values[0], values[1]).trim(), values[2], values[3]);
        }
        graphics2d.setFont(font);
    }

    public static void printString(Graphics graphics, String string, int x, int y, int width, int height, Alignment hCenter, Alignment vCenter) {
        VectorComponent.printString(graphics, string, x, y, width, height, hCenter, vCenter, 0.6);
    }

    public static void drawRect(Graphics graphics, int x, int y, int width, int height, float size) {
        Graphics2D graphics2d = (Graphics2D)graphics;
        Stroke oldStroke = graphics2d.getStroke();
        try {
            try {
                BasicStroke stroke = new BasicStroke(size);
                graphics2d.setStroke(stroke);
                graphics2d.drawRect(x, y, width, height);
            }
            catch (Exception e) {
                Log.log((Exception)e, (Level)Level.WARNING);
                graphics2d.setStroke(oldStroke);
            }
        }
        finally {
            graphics2d.setStroke(oldStroke);
        }
    }

    public void drawLargeLine(Graphics2D graphics, int x, int y, int x2, int y2, float size) {
        Stroke oldStroke = graphics.getStroke();
        try {
            try {
                BasicStroke stroke = new BasicStroke(size);
                graphics.setStroke(stroke);
                graphics.drawLine(x, y, x2, y2);
            }
            catch (Exception e) {
                Log.log((Exception)e, (Level)Level.WARNING);
                graphics.setStroke(oldStroke);
            }
        }
        finally {
            graphics.setStroke(oldStroke);
        }
    }

    public static void drawDebugRec(Graphics graphics, int x, int y, int width, int height, Color color) {
        Color saveColor = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(x, y, width, height);
        graphics.setColor(saveColor);
    }

    public static void drawDebugRec(Graphics graphics, int x, int y, int width, int height) {
        VectorComponent.drawDebugRec(graphics, x, y, width, height, Color.GREEN);
    }

    public void focus(boolean focus) {
        if (this.focused != focus) {
            this.focused = focus;
            if (focus) {
                this.fireGetFocus();
            } else {
                this.fireLostFocus();
            }
            this.repaint();
        } else if (this.focused && focus) {
            this.fireActionPerformed(new ActionEvent(this));
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setZoom(float value) {
        this.zoom = value;
        if (this.zoom > 1.0f) {
            this.zoom = 1.0f;
        }
        if (this.zoom < 0.0f) {
            this.zoom = 0.0f;
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public boolean isCliping() {
        return this.cliping;
    }

    public void setCliping(boolean cliping) {
        this.cliping = cliping;
    }

    public void repaint() {
        for (VectorComponentObserver observer : this.observers) {
            observer.componentChanged();
        }
    }

    public void addVectorComponentObserver(VectorComponentObserver observer) {
        this.observers.add(observer);
    }

    public void removeVectorComponentObserver(VectorComponentObserver observer) {
        this.observers.remove(observer);
    }

    public void addVectorComponentFocusObserver(VectorComponentFocusObserver observer) {
        this.vectorComponentFocusObservers.add(observer);
    }

    public void removeVectorComponentFocusObserver(VectorComponentFocusObserver observer) {
        this.vectorComponentFocusObservers.remove(observer);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListeners.add(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListeners.remove(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.add(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.remove(mouseMotionListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListeners.add(mouseWheelListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListeners.remove(mouseWheelListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    public void fireMouseCliked(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            for (MouseListener listener : this.mouseListeners) {
                listener.mouseClicked(e);
                if (e.isConsumed()) break;
            }
        }
    }

    public void fireMousePressed(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            for (MouseListener listener : this.mouseListeners) {
                listener.mousePressed(e);
                if (e.isConsumed()) break;
            }
        }
    }

    public void fireMouseReleased(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            for (MouseListener listener : this.mouseListeners) {
                listener.mouseReleased(e);
                if (e.isConsumed()) break;
            }
        }
    }

    public void fireMouseEntered(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            for (MouseListener listener : this.mouseListeners) {
                listener.mouseEntered(e);
                if (e.isConsumed()) break;
            }
        }
    }

    public void fireMouseExited(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            for (MouseListener listener : this.mouseListeners) {
                listener.mouseExited(e);
                if (e.isConsumed()) break;
            }
        }
    }

    public void fireMouseDragged(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
                mouseMotionListener.mouseDragged(e);
                if (e.isConsumed()) break;
            }
        }
    }

    public void fireMouseMoved(MouseEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
                mouseMotionListener.mouseMoved(e);
                if (e.isConsumed()) break;
            }
        }
    }

    public void fireMouseWheelMoved(MouseWheelEvent e) {
        if (this.moving()) {
            e.consume();
        }
        if (!e.isConsumed()) {
            for (MouseWheelListener mouseWheelListener : this.mouseWheelListeners) {
                mouseWheelListener.mouseWheelMoved(e);
                if (e.isConsumed()) break;
            }
        }
    }

    public void fireGetFocus() {
        for (VectorComponentFocusObserver vectorComponentFocusObserver : this.vectorComponentFocusObservers) {
            vectorComponentFocusObserver.componentGetfocus();
        }
    }

    public void fireLostFocus() {
        for (VectorComponentFocusObserver vectorComponentFocusObserver : this.vectorComponentFocusObservers) {
            vectorComponentFocusObserver.componentLostfocus();
        }
    }

    public void fireActionPerformed(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public String toString() {
        String string = this.userObject == null ? super.toString() : this.userObject.toString();
        return string;
    }

    public void destroy() {
        this.color = null;
        this.foregroundColor = null;
        this.userObject = null;
        this.focusable = false;
        this.focused = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        left,
        right,
        top,
        bottom,
        center;

    }
}

