/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.hdvui.view.vector.listener.event.ActionEvent;

public class VectorButton
extends VectorComponent {
    private boolean in;
    private boolean pushed;

    public VectorButton(Object text, Color color, Color foregroundColor, Font font) {
        super(text, color, foregroundColor, font);
        this.setFocusable(false);
    }

    public VectorButton(Object text, Color color, Font font) {
        super(text, color, Color.BLACK, font);
        this.setFocusable(false);
    }

    public VectorButton(Object text, Color color) {
        super(text, color);
        this.setFocusable(false);
    }

    public void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        super.paintComponent(graphics, x, y, width, height);
        if (this.pushed && this.in) {
            graphics.setColor(this.getColor().darker());
        } else {
            graphics.setColor(this.getColor());
        }
        graphics.fillRect(x, y, width, height);
        graphics.setColor(this.getForegroundColor());
        VectorComponent.drawRect(graphics, x, y, width, height, 1.0f);
        if (this.getUserObject() != null) {
            VectorComponent.printString(graphics, this.getUserObject().toString(), x, y, width, height, VectorComponent.Alignment.center, VectorComponent.Alignment.center);
        }
    }

    public void fireMousePressed(MouseEvent e) {
        this.pushed = true;
        e.consume();
        this.repaint();
        super.fireMousePressed(e);
    }

    public void fireMouseReleased(MouseEvent e) {
        this.pushed = false;
        this.repaint();
        super.fireMouseReleased(e);
    }

    public void fireMouseExited(MouseEvent e) {
        this.in = false;
        this.repaint();
        super.fireMouseExited(e);
    }

    public void fireMouseEntered(MouseEvent e) {
        this.in = true;
        this.repaint();
        super.fireMouseEntered(e);
    }

    public void fireMouseCliked(MouseEvent e) {
        super.fireMousePressed(e);
        if (!e.isConsumed()) {
            this.fireActionPerformed(new ActionEvent(this));
        }
    }

    public void fireMouseDragged(MouseEvent e) {
        if (this.pushed) {
            e.consume();
        }
        super.fireMouseDragged(e);
    }

    public void focus(boolean focus) {
    }
}

