/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.vector;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import me.iste.hdvui.view.vector.VectorArrow;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.hdvui.view.vector.VectorGroupe;
import me.iste.tools.instantiation.Instantiation;

public class ScrollVectorGroupe
extends VectorGroupe
implements MouseListener,
MouseMotionListener {
    private float pageIndex;
    private float newPageIndex;
    private VectorArrow leftArrow;
    private VectorArrow rightArrow;
    private boolean drag;
    private Point dragPoint;

    public ScrollVectorGroupe(Object text, Color color, Color foregroundColor, Font font) {
        super(text, color, foregroundColor, font);
    }

    public ScrollVectorGroupe(Object text, Color color, Font font) {
        super(text, color, font);
    }

    public ScrollVectorGroupe(Object text, Color color) {
        super(text, color);
    }

    public void init(float x, float y, int ipadx, int ipady) {
        super.init(x, y, ipadx, ipady);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.leftArrow = new VectorArrow(this.getForegroundColor());
        this.leftArrow.setDirection(1);
        this.rightArrow = new VectorArrow(this.getForegroundColor());
    }

    public void paintComponent(Graphics graphics, int x, int y, int width, int height) {
        super.paintComponent(graphics, x, y, width, height);
        int titleBarVSize = height * 15 / 100;
        int titleBarHSize = width * 10 / 100;
        if ((float)this.getVectorComponents().size() > this.getRow() * this.getColumn()) {
            float maxPage;
            this.leftArrow.setColor(this.getForegroundColor());
            this.rightArrow.setColor(this.getForegroundColor());
            if (this.newPageIndex > 0.0f) {
                this.leftArrow.paintComponent(graphics, x, y, titleBarHSize, titleBarVSize);
            }
            if (this.newPageIndex < (maxPage = (float)(Math.ceil((double)this.getVectorComponents().size() / Math.floor(this.getRow())) / (double)this.getColumn()) - 1.0f)) {
                this.rightArrow.paintComponent(graphics, x + width - titleBarHSize, y, titleBarHSize, titleBarVSize);
            }
        }
    }

    public void play() {
        this.pageIndex = (double)this.newPageIndex - 0.01 > (double)this.pageIndex ? (float)((double)this.pageIndex + 0.01) : ((double)this.newPageIndex + 0.01 < (double)this.pageIndex ? (float)((double)this.pageIndex - 0.01) : this.newPageIndex);
        super.play();
    }

    public boolean needPlay() {
        return super.needPlay() || this.pageIndex != this.newPageIndex;
    }

    protected void painElements(Graphics graphics, int x, int y, int width, int height) {
        int itemWidth = (int)((float)width / this.getColumn());
        int itemHeight = (int)((float)height / this.getRow());
        int xIndex = 0;
        int yIndex = 0;
        int xDraw = x + this.getPadx();
        int yDraw = y + this.getPady();
        float page = this.pageIndex;
        List components = Instantiation.getList();
        components.addAll(this.getVectorComponents());
        for (VectorComponent component : components) {
            int xComponent = (int)((float)(xDraw + xIndex * itemWidth) - page * (float)width);
            int yComponent = yDraw + yIndex * itemHeight;
            int widthComponent = itemWidth - 2 * this.getPadx();
            int heightComponent = itemHeight - 2 * this.getPady();
            component.paint(graphics, xComponent, yComponent, widthComponent, heightComponent);
            ++yIndex;
            if (!((double)yIndex >= Math.floor(this.getRow()))) continue;
            yIndex = 0;
            ++xIndex;
        }
    }

    public void setZoom(float value) {
        super.setZoom(value);
        float maxPage = (float)(Math.ceil((double)this.getVectorComponents().size() / Math.floor(this.getRow())) / (double)this.getColumn()) - 1.0f;
        if (this.pageIndex > maxPage) {
            this.pageIndex = maxPage;
            this.newPageIndex = maxPage;
        }
        if (this.pageIndex < 0.0f) {
            this.pageIndex = 0.0f;
            this.newPageIndex = 0.0f;
        }
    }

    public void setFocus(VectorComponent focus) {
        super.setFocus(focus);
        int componentPos = (int)((double)this.getVectorComponents().indexOf(focus) / Math.floor(this.getRow()));
        float pagePos = this.pageIndex * this.getColumn();
        float pagePosMax = this.pageIndex * this.getColumn() + this.getColumn() - 1.0f;
        if ((float)componentPos > pagePosMax) {
            this.newPageIndex = this.pageIndex + 1.0f / this.getColumn();
        } else if ((float)componentPos < pagePos) {
            this.newPageIndex = this.pageIndex - 1.0f / this.getColumn();
        }
        if (this.newPageIndex != this.pageIndex) {
            ScrollVectorGroupe.addToPlay(this);
        }
    }

    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
        int[] lastSeen = this.getLastSeen();
        float xpct = (e.getX() - lastSeen[0]) * 100 / lastSeen[2];
        float ypct = (e.getY() - lastSeen[1]) * 100 / lastSeen[3];
        if (xpct <= 10.0f && ypct <= 15.0f) {
            this.newPageIndex -= 1.0f;
            if (this.newPageIndex < 0.0f) {
                this.newPageIndex = 0.0f;
            }
        } else if (xpct >= 90.0f && ypct <= 15.0f) {
            this.newPageIndex = this.pageIndex + 1.0f;
            float maxPage = (float)(Math.ceil((double)this.getVectorComponents().size() / Math.floor(this.getRow())) / (double)this.getColumn()) - 1.0f;
            if (this.newPageIndex > maxPage) {
                this.newPageIndex = maxPage;
            }
            if (this.newPageIndex < 0.0f) {
                this.newPageIndex = 0.0f;
            }
        } else if (ypct > 15.0f) {
            this.drag = true;
            this.dragPoint = e.getPoint();
        }
        if (this.newPageIndex != this.pageIndex) {
            ScrollVectorGroupe.addToPlay(this);
        }
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        this.drag = false;
        this.dragPoint = null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.drag) {
            float dif = (float)((this.dragPoint.getX() - (double)e.getX()) / (double)this.getLastSeen()[2]);
            this.newPageIndex += dif;
            this.dragPoint = e.getPoint();
            e.consume();
            float maxPage = (float)(Math.ceil((double)this.getVectorComponents().size() / Math.floor(this.getRow())) / (double)this.getColumn()) - 1.0f;
            if (this.newPageIndex > maxPage) {
                this.newPageIndex = maxPage;
            }
            if (this.newPageIndex < 0.0f) {
                this.newPageIndex = 0.0f;
            }
            if (this.newPageIndex != this.pageIndex) {
                ScrollVectorGroupe.addToPlay(this);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

