/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.view.panel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import me.iste.hdvui.settings.SettingsConstantes;
import me.iste.hdvui.view.constantes.ColorConstantes;
import me.iste.hdvui.view.panel.LocatedComponent;
import me.iste.hdvui.view.panel.listener.VectorPanelListener;
import me.iste.hdvui.view.panel.observer.VectorPanelObserver;
import me.iste.hdvui.view.vector.VectorComponent;
import me.iste.hdvui.view.vector.observer.VectorComponentObserver;
import me.iste.tools.instantiation.Instantiation;
import me.iste.tools.settings.Settings;

public class VectorPanel
extends JPanel
implements VectorComponentObserver {
    private static final long serialVersionUID = 3314284129944134028L;
    private final List<LocatedComponent> components = Instantiation.getList();
    private final List<VectorComponent> removeLater = Instantiation.getList();
    private Color bkcolor = ColorConstantes.BACKGROUND;
    private LocatedComponent focus;
    private LocatedComponent lastDownClic;
    private LocatedComponent componentOver;
    private Point lastDownPoint;
    private final List<VectorPanelObserver> vectorPanelObservers;

    public VectorPanel() {
        VectorPanelListener listener = new VectorPanelListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.vectorPanelObservers = Instantiation.getList();
    }

    public void add(VectorComponent component, float x, float y, float z, float width, float height) {
        float[] values = new float[]{x, y, z, width, height};
        this.components.add(new LocatedComponent(component, values));
        component.addVectorComponentObserver(this);
        this.repaint();
    }

    public void add(VectorComponent component, float x, float y, float width, float height) {
        this.add(component, x, y, 0.0f, width, height);
    }

    public void remove(VectorComponent component, boolean force) {
        if (component != null) {
            List list = Instantiation.getList();
            list.addAll(this.components);
            for (LocatedComponent locatedComponent : list) {
                if (locatedComponent.getVectorComponent() != component) continue;
                if (component.needPlay() && !force) {
                    if (this.removeLater.contains(component)) continue;
                    this.removeLater.add(component);
                    continue;
                }
                this.components.remove(component);
                this.removeLater.remove(component);
                component.destroy();
                System.gc();
            }
        }
    }

    public void remove(VectorComponent component) {
        this.remove(component, false);
    }

    public void paint(Graphics graphics) {
        List toRemove = Instantiation.getList();
        toRemove.addAll(this.removeLater);
        for (VectorComponent vectorComponent : toRemove) {
            this.remove(vectorComponent);
        }
        graphics.setColor(this.bkcolor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Collections.sort(this.components);
        for (LocatedComponent locatedComponent : this.components) {
            float[] value = locatedComponent.getFs();
            VectorComponent vectorComponent = locatedComponent.getVectorComponent();
            int x = (int)((float)this.getWidth() * value[0] / 100.0f);
            int y = (int)((float)this.getHeight() * value[1] / 100.0f);
            int width = (int)((float)this.getWidth() * value[3] / 100.0f);
            int height = (int)((float)this.getHeight() * value[4] / 100.0f);
            vectorComponent.paint(graphics, x, y, width, height);
        }
    }

    public void setBackgroundColor(Color color) {
        this.bkcolor = color;
    }

    public void componentChanged() {
        this.repaint();
    }

    private LocatedComponent getComponentUnder(MouseEvent e) {
        LocatedComponent value = null;
        Collections.sort(this.components, Collections.reverseOrder());
        for (LocatedComponent component : this.components) {
            if (!component.getVectorComponent().isIn(e.getPoint())) continue;
            value = component;
            break;
        }
        return value;
    }

    public void fireMouseCliked(MouseEvent e) {
        LocatedComponent component = this.getComponentUnder(e);
        if (component != null) {
            component.getVectorComponent().fireMouseCliked(e);
        }
    }

    public void fireMousePressed(MouseEvent e) {
        LocatedComponent component = this.getComponentUnder(e);
        if (component != null) {
            component.getVectorComponent().fireMousePressed(e);
        }
        this.lastDownClic = component;
        this.lastDownPoint = e.getPoint();
        if (this.focus != null && this.focus != component) {
            this.focus.getVectorComponent().focus(false);
        }
    }

    public void fireMouseReleased(MouseEvent e) {
        LocatedComponent component = this.getComponentUnder(e);
        if (component != null) {
            if (this.lastDownPoint.distance(e.getX(), e.getY()) <= (double)((Integer)Settings.getInfo((String)SettingsConstantes.ERROR_CLIC_VALUE, Integer.class)).intValue() && component == this.lastDownClic) {
                if (this.focus != null && this.focus != component) {
                    this.focus.getVectorComponent().focus(false);
                }
                component.getVectorComponent().focus(true);
                this.focus = component;
            }
            component.getVectorComponent().fireMouseReleased(e);
            if (this.lastDownClic != null && this.lastDownClic != component) {
                this.lastDownClic.getVectorComponent().fireMouseReleased(e);
            }
        } else {
            if (this.focus != null) {
                this.focus.getVectorComponent().focus(false);
                this.focus = null;
            }
            if (this.lastDownClic != null) {
                this.lastDownClic.getVectorComponent().fireMouseReleased(e);
            }
        }
    }

    public void fireMouseEntered(MouseEvent e) {
    }

    public void fireMouseExited(MouseEvent e) {
    }

    public void fireMouseDragged(MouseEvent e) {
        LocatedComponent component = this.getComponentUnder(e);
        if (component != null) {
            component.getVectorComponent().fireMouseDragged(e);
        }
        if (this.componentOver != component) {
            if (this.componentOver != null) {
                this.componentOver.getVectorComponent().fireMouseExited(e);
            }
            if (component != null) {
                component.getVectorComponent().fireMouseEntered(e);
            }
        }
        this.componentOver = component;
    }

    public void fireMouseMoved(MouseEvent e) {
        LocatedComponent component = this.getComponentUnder(e);
        if (component != null) {
            component.getVectorComponent().fireMouseMoved(e);
        }
        if (this.componentOver != component) {
            if (this.componentOver != null) {
                this.componentOver.getVectorComponent().fireMouseExited(e);
            }
            if (component != null) {
                component.getVectorComponent().fireMouseEntered(e);
            }
        }
        this.componentOver = component;
    }

    public void fireMouseWheelMoved(MouseWheelEvent e) {
        LocatedComponent component = this.getComponentUnder(e);
        if (component != null) {
            component.getVectorComponent().fireMouseWheelMoved(e);
        }
    }

    public void addVectorPanelObservers(VectorPanelObserver observer) {
        this.vectorPanelObservers.add(observer);
    }

    public void removeVectorPanelObservers(VectorPanelObserver observer) {
        this.vectorPanelObservers.remove(observer);
    }

    public void firePanelClose() {
        for (VectorPanelObserver observer : this.vectorPanelObservers) {
            observer.panelClose();
        }
    }
}

