/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.tools.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shape {
    private static final Pattern PATTERN = Pattern.compile("^[ROPDLA],([DF]|[0-9]+),([PS]|([A-F0-9]{8}|[0-9]{12}))(,([D]*|[B]*))?(,[0-9]+){4,}$");
    private final ShapeType type;
    private final boolean fill;
    private final Integer size;
    private final ColorType colorType;
    private final Color color;
    private final int colorModifier;
    private final List<Integer> xs;
    private final List<Integer> ys;

    public Shape(String value) {
        int index;
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        String[] values = value.split(",");
        if (values[index = 0].equals("R")) {
            this.type = ShapeType.rectangle;
        } else if (values[index].equals("O")) {
            this.type = ShapeType.oval;
        } else if (values[index].equals("P")) {
            this.type = ShapeType.polygon;
        } else if (values[index].equals("D")) {
            this.type = ShapeType.roundRect;
        } else if (values[index].equals("L")) {
            this.type = ShapeType.line;
        } else if (values[index].equals("A")) {
            this.type = ShapeType.arc;
        } else {
            this.type = ShapeType.rectangle;
            throw new IllegalArgumentException();
        }
        if (values[++index].equals("F")) {
            this.fill = true;
            this.size = null;
        } else if (values[index].equals("D")) {
            this.fill = false;
            this.size = null;
        } else {
            this.fill = false;
            this.size = new Integer(values[index]);
        }
        if (values[++index].equals("P")) {
            this.colorType = ColorType.primary;
            this.color = null;
        } else if (values[index].equals("S")) {
            this.colorType = ColorType.secondary;
            this.color = null;
        } else {
            int a;
            int b;
            int g;
            int r;
            this.colorType = ColorType.custom;
            if (values[index].length() == 12) {
                r = Integer.parseInt(values[index].substring(0, 2));
                g = Integer.parseInt(values[index].substring(2, 4));
                b = Integer.parseInt(values[index].substring(4, 6));
                a = Integer.parseInt(values[index].substring(6, 8));
            } else {
                r = Integer.parseInt(values[index].substring(0, 2), 16);
                g = Integer.parseInt(values[index].substring(2, 4), 16);
                b = Integer.parseInt(values[index].substring(4, 6), 16);
                a = Integer.parseInt(values[index].substring(6, 8), 16);
            }
            this.color = new Color(r, g, b, a);
        }
        int modifier = 0;
        if (values[++index].startsWith("D")) {
            modifier -= values[index].length();
            ++index;
        } else if (values[index].startsWith("B")) {
            modifier += values[index].length();
            ++index;
        }
        this.colorModifier = modifier;
        this.xs = new ArrayList<Integer>();
        this.ys = new ArrayList<Integer>();
        while (index < values.length) {
            this.xs.add(Integer.parseInt(values[index]));
            this.ys.add(Integer.parseInt(values[++index]));
            ++index;
        }
    }

    public ShapeType getType() {
        return this.type;
    }

    public Integer getSize() {
        return this.size;
    }

    public boolean isFill() {
        return this.fill;
    }

    public ColorType getColorType() {
        return this.colorType;
    }

    public Color getColor() {
        return this.color;
    }

    public int getColorModifier() {
        return this.colorModifier;
    }

    public List<Integer> getXs() {
        return this.xs;
    }

    public List<Integer> getYs() {
        return this.ys;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " :\nType = " + (Object)((Object)this.type) + "\nFill = " + this.fill + "\nColor Type = " + (Object)((Object)this.colorType) + "\nColor = " + this.color + "\nColor Modifier = " + this.colorModifier + "\nX = " + this.xs + "\nY = " + this.ys;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorType {
        primary,
        secondary,
        custom;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShapeType {
        rectangle,
        oval,
        polygon,
        roundRect,
        line,
        arc;

    }
}

