/*
 * Decompiled with CFR 0.152.
 */
package me.iste.hdvui.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import me.iste.hdvui.tools.util.Shape;
import me.iste.tools.exceptions.InitialisationException;
import me.iste.tools.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconTools {
    private static final String DEFAULT_PATH = "icons";
    private static String iconPath = "";

    private IconTools() {
    }

    public static void init(String path) throws InitialisationException {
        File filePath = new File(path);
        filePath.mkdirs();
        if (!filePath.exists() || !filePath.isDirectory()) {
            throw new InitialisationException(String.format("The path is not a directory or not existe : \n%s", filePath.getPath()));
        }
        iconPath = path;
    }

    public static void init() throws InitialisationException {
        IconTools.init(DEFAULT_PATH);
    }

    public static List<Shape> getIconShapes(String iconName) {
        File iconPathFile = new File(iconPath);
        File iconFile = new File(String.valueOf(iconPathFile.getPath()) + File.separatorChar + iconName);
        if (!iconFile.exists() || !iconFile.isFile()) {
            String message = String.format("Icon not found : \n%s", iconFile.getPath());
            Log.log((String)message, (Level)Level.WARNING);
            throw new IllegalArgumentException(message);
        }
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        try {
            Scanner scanner = new Scanner(iconFile);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                try {
                    shapes.add(new Shape(line));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.log((String)e.getMessage(), (Level)Level.SEVERE);
        }
        return shapes;
    }
}

